"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.commandStopScanning = exports.commandStartScanning = exports.commandSetLicenseExpirationTimestamp = exports.commandActivateNativeService = void 0;
var process_scanning_native_api_1 = require("./process-scanning-native-api");
var commandActivateNativeService = function () { return ({
    commandName: process_scanning_native_api_1.CommandNames.activateNativeService,
    payload: {},
}); };
exports.commandActivateNativeService = commandActivateNativeService;
var commandSetLicenseExpirationTimestamp = function (date) { return ({
    commandName: process_scanning_native_api_1.CommandNames.setLicenseExpirationTimestamp,
    payload: { licenseExpirationTimestamp: Math.floor(date.getTime() / 1000) },
}); };
exports.commandSetLicenseExpirationTimestamp = commandSetLicenseExpirationTimestamp;
var commandStartScanning = function () { return ({
    commandName: process_scanning_native_api_1.CommandNames.startScanning,
    payload: {},
}); };
exports.commandStartScanning = commandStartScanning;
var commandStopScanning = function () { return ({
    commandName: process_scanning_native_api_1.CommandNames.stopScanning,
    payload: {},
}); };
exports.commandStopScanning = commandStopScanning;
